/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package rdc;

import com.inet.report.Area;
import com.inet.report.Box;
import com.inet.report.Element;
import com.inet.report.Engine;

/**
 * This class explains how you can set a background color of a box that is included in the page header section
 */
public class BackgroundColorInBox extends RDCSample {

    /**
     * Set the background color for a box in the page header section
     * @param exportFmt output format
     * @return engine the engine for the specified report
     */
    @Override
    public Engine createAndFillEngine( String exportFmt ) {

        try {
            // create a new Engine
            Engine eng = new Engine( exportFmt );
            // set the name of the report file
            eng.setReportFile( "samples/rdc/box_with_background.rpt" );

            // get the PageHeader area
            Area area = eng.getArea( "PH" );
            // get all elements in the PageHeader section
            Element[] sectionElements = area.getSection( 0 ).getElements();
            for( int i = 0; i < sectionElements.length; i++ ) {
                // search a box in the PageHeader section
                if( sectionElements[i] instanceof Box ) {
                    // set the background color for these box
                    sectionElements[i].setBackColor( 0x10705C );
                }
            }
            return eng;
        } catch( Throwable e ) {
            e.printStackTrace();
            System.exit( 0 );
            return null;
        }
    }

    /**
     * Main method of this sample
     * @param args arguments not used
     */
    public static void main( String[] args ) {
        new BackgroundColorInBox().initUI();
    }
}
